<?php
include_once __DIR__ . '/../framework/init.php';
include_once __DIR__ . '/AcelleMail.php';

class AcelleWPWorkflowsTrigger
{

    public function __construct()
    {
        $objSync = new AcelleWPWorkflowsSync();

        add_action('init', array($this, 'initializeSync'));

    }

    public function initializeSync()
    {
        
        $allRulesAdded = get_option('CAI_RULES');
        if ($allRulesAdded) {
            $rules = $allRulesAdded['frm_rule'];

            do_action('acellemail_wp_custom_trigger', $rules);

            if ($rules) {
                foreach ($rules as $key => $rule) {
                    if ($rule['trigger'] == 'trigger_wp_registration') {
                        $this->trigger_wp_registration();
                    }
                    if ($rule['trigger'] == 'trigger_edd_purchase') {
                        $this->trigger_edd_purchase();
                    }
                    if ($rule['trigger'] == 'trigger_edd_subscription_updated') {
                        $this->trigger_edd_subscription_updated();
                    }
                    if ($rule['trigger'] == 'trigger_new_edd_subscription') {
                        $this->trigger_new_edd_subscription();
                    }
                }
            }
        }
    }

    public function trigger_new_edd_subscription()
    {
        $allRulesAdded = get_option('CAI_RULES');
        if ($allRulesAdded) {
            $rules = $allRulesAdded['frm_rule'];
            if ($rules) {
                foreach ($rules as $key => $rule) {
                    if ($rule['trigger'] == 'trigger_new_edd_subscription') {
                        add_action('edd_recurring_setup_subscription', array($this, 'edd_recurring_setup_subscription_callback'));
                    }
                }
            }
        } 
    }

    public function edd_recurring_setup_subscription_callback( EDD_Subscription $subscription )
    {
        if( ! $subscription || ! $subscription->id > 0 ) {
			return;
		}

		if( ! empty( $subscription->transaction_id ) ) {
			return;
		}

		if( 'stripe' !== $subscription->gateway ) {
			return;
		}

		if( empty( $subscription->profile_id ) ) {
			return;
		}

		if( ! empty( $subscription->transaction_id ) ) {
			return;
        }
         
        if ($subscription->id > 0) {
            $subscriber['EMAIL'] = $subscription->customer->email;
            $allRulesAdded = get_option('CAI_RULES');
            if ($allRulesAdded) {
                $rules = $allRulesAdded['frm_rule'];
                if ($rules) {
                    foreach ($rules as $key => $rule) {
                        // is subscription id the product id
                        if ($rule['trigger'] == 'trigger_new_edd_subscription' &&  in_array($subscription->product_id, $rule['trigger_option'])) {
                            $objSync = new AcelleWPWorkflowsSync();
                            $objSync->perform_action($rule['action'], $rule['action_option'][0], $subscriber);
                        }
                    }
                }
            }
        }

    }

    public function trigger_edd_subscription_updated() 
    {
        $allRulesAdded = get_option('CAI_RULES');
        if ($allRulesAdded) {
            $rules = $allRulesAdded['frm_rule'];
            if ($rules) {
                foreach ($rules as $key => $rule) {
                    if ($rule['trigger'] == 'trigger_edd_subscription_updated') {
                        if ($rule['action_option'][0] == 'Cancelled')
                        {
                            add_action('edd_subscription_cancelled', array($this,'edd_subscription_cancelled_callback'), 10, 2);
                        } else if ($rule['action_option'][0] == 'Completed') {
                            add_action('edd_subscription_completed', array($this, 'edd_subscription_completed_callback'), 10, 2);
                        } else if ($rules['action_option'][0] == 'Expired') {
                            add_action('edd_subscription_expired', array($this, 'edd_subscription_expired_callback'), 10 , 2);
                        }
                        
                    }
                }
            }
        }        
    }

    public function edd_subscription_cancelled_callback($subscription_id = 0,  EDD_Subscription $subscription )
    {
        if ($subscription_id > 0) {
            $subscriber['EMAIL'] = $subscription->customer->email;
            $allRulesAdded = get_option('CAI_RULES');
            if ($allRulesAdded) {
                $rules = $allRulesAdded['frm_rule'];
                if ($rules) {
                    foreach ($rules as $key => $rule) {
                        if ($rule['trigger'] == 'trigger_edd_subscription_updated' && $rule['trigger_option'][0] == 'Cancelled') {
                            $objSync = new AcelleWPWorkflowsSync();
                            $objSync->perform_action($rule['action'], $rule['action_option'][0], $subscriber);
                        }
                    }
                }
            }
        }
    }
    

    public function edd_subscription_completed_callback($subscription_id = 0,  EDD_Subscription $subscription)
    {
        if ($subscription_id > 0) {
            $subscriber['EMAIL'] = $subscription->customer->email;
            $allRulesAdded = get_option('CAI_RULES');
            if ($allRulesAdded) {
                $rules = $allRulesAdded['frm_rule'];
                if ($rules) {
                    foreach ($rules as $key => $rule) {
                        if ($rule['trigger'] == 'trigger_edd_subscription_updated' && $rule['trigger_option'][0] == 'Completed') {
                            $objSync = new AcelleWPWorkflowsSync();
                            $objSync->perform_action($rule['action'], $rule['action_option'][0], $subscriber);
                        }
                    }
                }
            }
        }
    }

    public function edd_subscription_expired_callback($subscription_id = 0,  EDD_Subscription $subscription)
    {
        if ($subscription_id > 0) {
            $subscriber['EMAIL'] = $subscription->customer->email;
            $allRulesAdded = get_option('CAI_RULES');
            if ($allRulesAdded) {
                $rules = $allRulesAdded['frm_rule'];
                if ($rules) {
                    foreach ($rules as $key => $rule) {
                        if ($rule['trigger'] == 'trigger_edd_subscription_updated' && $rule['trigger_option'][0] == 'Expired') {
                            $objSync = new AcelleWPWorkflowsSync();
                            $objSync->perform_action($rule['action'], $rule['action_option'][0], $subscriber);
                        }
                    }
                }
            }
        }
    }

    public function edd_complete_purchase_callback($payment_id) 
    {
        $user_info = edd_get_payment_meta_user_info($payment_id);
        $subscriber = [];
        $downloadIds = [];

        $payment = new EDD_Payment( $payment_id );
        if (!empty($payment->cart_details) && $payment->cart_details) {
          $cart_details   = $payment->cart_details;
          if ( is_array( $cart_details ) ) {
            foreach ( $cart_details as $cart_index => $download ) {
                 $downloadIds[] = $download['id'];
            }
          }
        }

       
        if (isset($user_info['email'])) {
            $subscriber['EMAIL'] = $user_info['email'];
        }
        if (isset($user_info['first_name'])) {
            $subscriber['FIRST_NAME'] = $user_info['first_name'];
        }
        if (isset($user_info['last_name'])) {
            $subscriber['LAST_NAME'] = $user_info['last_name'];
        }
        $allRulesAdded = get_option('CAI_RULES');
        if ($allRulesAdded) {
            $rules = $allRulesAdded['frm_rule'];
            if ($rules) {
                foreach ($rules as $key => $rule) {
                    if ($rule['trigger'] == 'trigger_edd_purchase') {
                        $exist = false;
                        foreach($downloadIds as $ids) {
                            if (in_array($ids, $rule['trigger_option'])) {
                                $exist = true;
                            }
                        }
                        if ($exist) {
                          $objSync = new AcelleWPWorkflowsSync();
                          $objSync->perform_action($rule['action'], $rule['action_option'][0], $subscriber);      
                        }
                    }
                }
            }
        }

    }

 
    public function trigger_edd_purchase()
    {
        add_action('edd_complete_purchase', array($this, 'edd_complete_purchase_callback'), 10, 1);
    }

    public function user_register_callback($user_id) {
        $user_detail = get_user_by('id', $user_id);

        $user_detail = (array) $user_detail->data;
        $subscriber = [];
        if (isset($user_detail['user_email'])) {
            $subscriber['EMAIL'] = $user_detail['user_email'];
        }
        
        if (isset($user_detail['user_nicename'])) {
            $subscriber['FIRST_NAME'] = $user_detail['user_nicename'];
        }
        if (isset($user_detail['first_name'])) {
            $subscriber['FIRST_NAME'] = $user_detail['first_name'];
        }
        if (isset($user_detail['last_name'])) {
            $subscriber['LAST_NAME'] = $user_detail['last_name'];
        }

        $allRulesAdded = get_option('CAI_RULES');
        if ($allRulesAdded) {
            $rules = $allRulesAdded['frm_rule'];
            if ($rules) {
                foreach ($rules as $key => $rule) {
                    if ($rule['trigger'] == 'trigger_wp_registration') {
                        $objSync = new AcelleWPWorkflowsSync();
                        $objSync->perform_action($rule['action'], $rule['action_option'][0], $subscriber);
                    }
                }
            }
        }

    }

    public function trigger_wp_registration()
    {
        add_action('user_register', array($this, 'user_register_callback'),10,1);
    }

}
